unit FormOsoby;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ExtCtrls, ActnList, Buttons, Grids, DBGrids, DBXpress,
  DB;

type
  TFOsoby = class(TForm)
    Panel1: TPanel;
    StatusBar1: TStatusBar;
    SpeedButton1: TSpeedButton;
    ActionList1: TActionList;
    ActionClose: TAction;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    DBGrid1: TDBGrid;
    ActionEdit: TAction;
    ActionInsert: TAction;
    ActionDelete: TAction;
    procedure ActionCloseExecute(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure DBGrid1DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
    procedure FormCreate(Sender: TObject);
    procedure DBGrid1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure DBGrid1TitleClick(Column: TColumn);
    procedure SpeedButton2Click(Sender: TObject);
    procedure ActionEditExecute(Sender: TObject);
    procedure ActionInsertExecute(Sender: TObject);
    procedure ActionDeleteExecute(Sender: TObject);
  private

  public

    procedure my_edit();
    procedure my_insert();
    procedure my_delete();

    procedure pokaz_osoby();    
  end;

var
  FOsoby: TFOsoby;

implementation
{$R *.dfm}

uses
   DataModule, DialogOsoba, SqlExpr;

procedure TFOsoby.ActionCloseExecute(Sender: TObject);
begin
   Close();
end;

procedure TFOsoby.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
end;

procedure TFOsoby.FormDestroy(Sender: TObject);
begin
   FOsoby := NIL;
end;

procedure TFOsoby.FormCreate(Sender: TObject);
begin
   Left  := 0;
   Width := Screen.Width;
end;

procedure TFOsoby.ActionDeleteExecute(Sender: TObject);
begin
   my_delete();
end;

procedure TFOsoby.ActionEditExecute(Sender: TObject);
begin
   my_edit();
end;

procedure TFOsoby.ActionInsertExecute(Sender: TObject);
begin
   my_insert();
end;

procedure TFOsoby.DBGrid1DrawColumnCell(Sender: TObject;
                                        const Rect: TRect;
                                        DataCol: Integer;
                                        Column: TColumn;
                                        State: TGridDrawState);
var
   mcowosc : String;

begin
   // wywietla kolumny nazwisko i imie w innym kolorze
   if (Column.Field = DM.ClientDataSet1.FieldByName('NAZWISKO')) or
      (Column.Field = DM.ClientDataSet1.FieldByName('IMIE'))     then begin

      DBgrid1.Canvas.Font.Color := clSkyBlue;
   end
   else begin
      // DBgrid1.Canvas.Font.Color := clRed;
   end;

   // osoby ktre urudziy sie w innym miecie ni Katowice BOLD
   // DBgrid1.TitleFont.Name := 'Times new Roman';
   mcowosc := DM.ClientDataSet1.FieldByName('MCOWOSC').AsString;
   if (Uppercase(mcowosc) <> 'KATOWICE') then begin
      // DBgrid1.Canvas.Font.Color := clBlue;
      DBgrid1.Canvas.Font.Style := [fsBold];
   end
   else begin
      // DBgrid1.Canvas.Font.Color := clBlack;
   end;
   

   // narysuj standardowy tekst
   DbGrid1.DefaultDrawDataCell(Rect, Column.Field, State);
end;

procedure TFOsoby.DBGrid1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin  
   if Key = VK_INSERT then begin
      my_insert();
   end;

   if Key = VK_RETURN then begin
      my_edit();
   end;

   if Key = VK_DELETE then begin
      my_delete();
   end;
end;

procedure TFOsoby.my_edit();
var
   Res  : TModalResult;  // bada w jaki sposb zostao zamkniete okno dialogowe
   ilel : Integer;       // ilo elementw w ListView

begin
   // edycja ma sens jeeli lista nie jest pusta
   ilel := DM.ClientDataSet1.RecordCount;
   if ilel = 0 then begin
      EXIT;
   end;

   try
      DlgOsoba := TDlgOsoba.Create(Self, True);
      res      := DlgOsoba.ShowModal();

      if res = mrOK then begin
         pokaz_osoby();
      end;
   finally
      FreeAndNil(DlgOsoba);
   end;
end;

procedure TFOsoby.my_delete();
var
   TD      : TTransactionDesc;
   ilel    : integer;
   poz     : integer;
   idosoby : Integer;

begin
   // edycja ma sens jeeli lista nie jest pusta
   ilel := DM.ClientDataSet1.RecordCount;
   if ilel = 0 then begin
      EXIT;
   end;

   if MessageBox(0, PChar('Usun rekord ?'), 'Ostrzeenie', MB_YESNO ) = IDYES then begin
      idosoby := DM.ClientDataSet1.FieldByName('IDOSOBY').AsInteger;
      try
         try
            if not DM.SQLConnection1.InTransaction then begin
               DM.SQLDataSet1.Close();

               TD.TransactionID  := 1;
               TD.IsolationLevel := xilREADCOMMITTED;

               DM.SQLConnection1.StartTransaction(TD);
               DM.SQLDataSetDelete.ParamByName('IDOSOBY').AsInteger := idosoby;

               DM.SQLDataSetDelete.ExecSQL();

               DM.SQLConnection1.Commit(TD);

               pokaz_osoby();

               ModalResult := mrOK;
            end
            else begin
               ShowMessage('InTransaction');
            end;
         except
            DM.SQLConnection1.Rollback(TD);
            ShowMessage('Rollback');
         end;
      finally
         DM.SQLDataSetDelete.Close();
         DBGrid1.SetFocus();
      end;
   end
end;

procedure TFOsoby.my_insert();
var
   Res : TModalResult;

begin
   try
      DlgOsoba := TDlgOsoba.Create(Self, False);
      res      := DlgOsoba.ShowModal();

      if res = mrOK then begin
         pokaz_osoby();
      end;
   finally
      FreeAndNil(DlgOsoba);
   end;
end;

procedure TFOsoby.DBGrid1TitleClick(Column: TColumn);
begin
   if Column.FieldName = DM.ClientDataSet1.IndexFieldNames then begin
      try
         DM.ClientDataSet1.DeleteIndex('PESEL');
      except
         DM.ClientDataSet1.AddIndex('PESEL',Column.FieldName, [ixDescending]);
         DM.ClientDataSet1.IndexName := 'PESEL';
      end;
   end
   else begin
      DM.ClientDataSet1.IndexName := '';
      DM.ClientDataSet1.IndexFieldNames := Column.FieldName;
   end;
end;

procedure TFOsoby.pokaz_osoby();
begin
   DM.ClientDataSet1.Close();
   DM.SQLDataSet1.Close();

   DM.ClientDataSet1.Open();
   DM.SQLDataSet1.Open();
end;


procedure TFOsoby.SpeedButton2Click(Sender: TObject);
begin
   my_edit();
end;

end.

